#!/bin/bash

# Simple startup script for DWS Policy Chatbot
# No technical knowledge required - just run this script!

echo "=========================================="
echo "  DWS Policy Chatbot - Starting..."
echo "=========================================="
echo ""

# Set the API key
export OPENAI_API_KEY="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"

# Check if Python is installed
if ! command -v python3 &> /dev/null; then
    echo "❌ Python 3 is not installed."
    echo "Please install Python 3 first."
    exit 1
fi

echo "✓ Python 3 found"

# Install dependencies if needed
echo ""
echo "Installing required packages..."
cd backend
pip3 install -q -r requirements.txt --user
cd ..

echo "✓ Packages installed"
echo ""

# Start the backend
echo "Starting backend server..."
echo "Backend will run on: http://localhost:8000"
echo ""

cd backend
python3 app.py &
BACKEND_PID=$!

# Wait for backend to start
sleep 3

# Check if backend is running
if curl -s http://localhost:8000/health > /dev/null 2>&1; then
    echo "✓ Backend is running!"
else
    echo "❌ Backend failed to start. Check the logs above."
    exit 1
fi

# Start the frontend
echo ""
echo "Starting frontend server..."
echo "Frontend will run on: http://localhost:8080"
echo ""

cd ../frontend
python3 -m http.server 8080 &
FRONTEND_PID=$!

sleep 2

echo ""
echo "=========================================="
echo "  ✓ Chatbot is ready!"
echo "=========================================="
echo ""
echo "Open your web browser and visit:"
echo ""
echo "  Main Chat:    http://localhost:8080/index.html"
echo "  Admin Panel:  http://localhost:8080/admin.html"
echo "  Widget Demo:  http://localhost:8080/embed.html"
echo ""
echo "Press Ctrl+C to stop the servers"
echo ""

# Wait for user to stop
wait
