# Simple Guide - For Non-Technical Users

This guide will help you run the chatbot on your computer in just a few clicks!

## 📋 What You Need

1. **Python 3** - A programming language (free to download)
2. **A web browser** - Chrome, Firefox, Safari, or Edge
3. **This folder** - The chatbot files you received

## 🚀 How to Start the Chatbot

### On Windows

1. **Install Python** (if not already installed)
   - Go to: https://www.python.org/downloads/
   - Click "Download Python"
   - Run the installer
   - ✅ **IMPORTANT**: Check the box "Add Python to PATH"
   - Click "Install Now"

2. **Start the Chatbot**
   - Find the file `start.bat` in the chatbot folder
   - **Double-click** `start.bat`
   - A black window will open - wait for it to say "Chatbot is ready!"

3. **Open in Browser**
   - Open your web browser
   - Type in the address bar: `http://localhost:8080/index.html`
   - Press Enter
   - The chatbot will appear!

4. **Stop the Chatbot**
   - Go back to the black window
   - Press any key to stop

### On Mac/Linux

1. **Install Python** (if not already installed)
   - Mac: Python is usually pre-installed
   - Linux: Run `sudo apt install python3`

2. **Start the Chatbot**
   - Open Terminal (search for "Terminal" in your applications)
   - Type: `cd ` (with a space after cd)
   - Drag the chatbot folder into the Terminal window
   - Press Enter
   - Type: `./start.sh`
   - Press Enter
   - Wait for "Chatbot is ready!"

3. **Open in Browser**
   - Open your web browser
   - Type: `http://localhost:8080/index.html`
   - Press Enter

4. **Stop the Chatbot**
   - Go back to Terminal
   - Press Ctrl+C

## 💬 How to Use the Chatbot

Once the chatbot opens in your browser:

1. **Type your question** in the box at the bottom
2. **Press Enter** or click the send button
3. **Wait a few seconds** for the AI to respond
4. **Ask more questions** - it remembers your conversation!

### Example Questions

- "What is the sick leave policy?"
- "How many days notice period do I need to give?"
- "What is the probation period?"
- "How do I contact HR?"
- "What are the working hours?"

## 📝 How to Update Company Policies

You can update the policies without any coding!

1. **Find the file**
   - Go to the `data` folder
   - Open `company_policies.txt`

2. **Edit the file**
   - Open it with Notepad (Windows) or TextEdit (Mac)
   - Make your changes
   - Save the file

3. **Reload the policies**
   - In your browser, go to: `http://localhost:8080/admin.html`
   - Click the blue "Reload Policies" button
   - Done! The chatbot now knows the new policies

**No need to restart anything!**

## 🌐 How to Put It on Your Website

To add the chatbot to your company website, you'll need to:

1. **Upload to a server** - Ask your IT team to:
   - Upload the chatbot folder to your web server
   - Follow the `DEPLOYMENT_CHECKLIST.md`

2. **Get the URL** - Your IT team will give you a URL like:
   - `https://chatbot.yourcompany.com`

3. **Add to website** - Give this code to your web developer:
   ```html
   <iframe src="https://chatbot.yourcompany.com/embed.html" 
           style="position: fixed; bottom: 0; right: 0; 
                  width: 100%; height: 100%; border: none; 
                  z-index: 9999; pointer-events: none;">
   </iframe>
   ```

This will add a floating chat button to your website!

## 🆘 Troubleshooting

### "Python is not recognized"
- You need to install Python
- Make sure you checked "Add Python to PATH" during installation
- Restart your computer after installing

### "Port already in use"
- Another program is using the same port
- Restart your computer and try again
- Or ask your IT team for help

### Chatbot gives wrong answers
- Check if the policy file is correct
- Go to admin panel and click "Reload Policies"
- Make sure the policy text is clear and well-formatted

### Can't connect to backend
- Make sure the backend is running (the black window should be open)
- Try restarting: close everything and run `start.bat` again

### Browser shows "Can't reach this page"
- Make sure you typed the URL correctly: `http://localhost:8080/index.html`
- Make sure the chatbot is running (black window is open)
- Try a different browser

## 💡 Tips

1. **Keep the black window open** - This is the server running. Don't close it!
2. **Use Chrome or Firefox** - They work best with the chatbot
3. **Test before deploying** - Try asking different questions to make sure answers are correct
4. **Update policies regularly** - Keep the policy file up to date
5. **Ask your IT team** - If you need help deploying to a server

## 📞 Need Help?

If you're stuck:

1. **Check this guide again** - Read it carefully
2. **Ask your IT team** - They can help with technical issues
3. **Check the other guides**:
   - `QUICKSTART.md` - More detailed instructions
   - `README.md` - Complete documentation
   - `DEPLOYMENT_CHECKLIST.md` - For server deployment

## ✅ Quick Checklist

Before you start:
- [ ] Python 3 is installed
- [ ] You have the chatbot folder
- [ ] You have a web browser

To run the chatbot:
- [ ] Double-click `start.bat` (Windows) or run `./start.sh` (Mac/Linux)
- [ ] Wait for "Chatbot is ready!"
- [ ] Open browser to `http://localhost:8080/index.html`
- [ ] Start asking questions!

To update policies:
- [ ] Edit `data/company_policies.txt`
- [ ] Save the file
- [ ] Go to `http://localhost:8080/admin.html`
- [ ] Click "Reload Policies"

---

**That's it! You're ready to use your AI chatbot! 🤖**

If you can use Microsoft Word, you can manage this chatbot!
