# Quick Start Guide - DWS Policy Chatbot

Get your chatbot up and running in 5 minutes!

## 🚀 Step 1: Install Dependencies

```bash
cd company-policy-chatbot/backend
pip3 install -r requirements.txt
```

## 🔑 Step 2: Set Your API Key

**Linux/Mac:**
```bash
export OPENAI_API_KEY="your-api-key-here"
```

**Windows (Command Prompt):**
```cmd
set OPENAI_API_KEY=your-api-key-here
```

**Windows (PowerShell):**
```powershell
$env:OPENAI_API_KEY="your-api-key-here"
```

## ▶️ Step 3: Start the Backend

```bash
cd backend
python3 app.py
```

You should see:
```
INFO:     Started server process
INFO:     Uvicorn running on http://0.0.0.0:8000
```

## 🌐 Step 4: Open the Frontend

**Option A: Direct File Access**
- Open `frontend/index.html` in your web browser

**Option B: Local Server (Recommended)**
```bash
cd frontend
python3 -m http.server 8080
```
Then visit: http://localhost:8080

## ✅ Step 5: Test It!

Ask the chatbot questions like:
- "What is the sick leave policy?"
- "What is the notice period for a manager?"
- "How do I contact HR?"
- "What is the probation period?"

## 📝 Updating Policies

1. Edit `data/company_policies.txt`
2. Save the file
3. Visit http://localhost:8080/admin.html
4. Click "Reload Policies"

That's it! No restart needed.

## 🌐 Embedding in Your Website

Add this code to your website:

```html
<!-- Full Page Embed -->
<iframe 
    src="http://your-server:8080/index.html" 
    width="100%" 
    height="600px" 
    frameborder="0">
</iframe>

<!-- OR Widget (Floating Button) -->
<iframe 
    src="http://your-server:8080/embed.html" 
    style="position: fixed; bottom: 0; right: 0; width: 100%; height: 100%; border: none; z-index: 9999; pointer-events: none;">
</iframe>
```

## 🐛 Troubleshooting

**Backend won't start?**
- Check if port 8000 is free: `lsof -i :8000` (Linux/Mac)
- Verify API key is set: `echo $OPENAI_API_KEY`

**Frontend can't connect?**
- Make sure backend is running on port 8000
- Check `frontend/script.js` - API_URL should be `http://localhost:8000`

**Wrong answers?**
- Check if policies loaded: `curl http://localhost:8000/policy-info`
- Reload policies: `curl -X POST http://localhost:8000/reload-policies`

## 📚 Need More Help?

See the full [README.md](README.md) for:
- Production deployment guide
- Nginx configuration
- SSL setup
- Advanced configuration
- Security best practices

---

**Happy Chatting! 🤖**
