# Google Docs Integration Guide

## 🎉 What's New

Your chatbot now reads policies **directly from Google Docs**! This means:

✅ **Easy Updates** - Edit your Google Doc anytime, bot gets latest content  
✅ **No Dev Team Needed** - Update policies yourself without technical help  
✅ **Instant Changes** - Click "Reload Policies" and changes take effect immediately  
✅ **Always in Sync** - Your team always sees the most current policies  

---

## 📄 Your Google Doc

**Document URL:**
```
https://docs.google.com/document/d/1I3XoFUvTFgjJPck8MahPeAIMuodlkPZSj4Y7kyVXscI/edit
```

**Document ID:** `1I3XoFUvTFgjJPck8MahPeAIMuodlkPZSj4Y7kyVXscI`

---

## 🔓 Important: Document Must Be Public

For the chatbot to read your Google Doc, it must be set to **"Anyone with the link can view"**.

### How to Check/Set Permissions:

1. **Open your Google Doc**
2. **Click "Share"** button (top right)
3. **Under "General access"**, select **"Anyone with the link"**
4. **Set permission to "Viewer"** (not Editor)
5. **Click "Done"**

✅ Your document is already set to public, so you're good to go!

---

## ✏️ How to Update Policies

### Step 1: Edit Your Google Doc

1. Open your Google Doc: https://docs.google.com/document/d/1I3XoFUvTFgjJPck8MahPeAIMuodlkPZSj4Y7kyVXscI/edit
2. Make your changes (add, edit, or delete policies)
3. Google Docs auto-saves - no need to click save!

### Step 2: Reload Policies in Chatbot

**Option A: Via Admin Panel (Easy)**
1. Go to: `http://your-domain.com/admin.html`
2. Click the **"Reload Policies"** button
3. You'll see a success message
4. Done! Bot now uses the updated policies

**Option B: Via API (For Developers)**
```bash
curl -X POST http://your-domain.com/api/reload-policies
```

### Step 3: Test the Changes

1. Go to the chatbot
2. Ask a question about the policy you updated
3. Verify the bot gives the new answer

---

## 🔄 How It Works

### On Startup:
1. Bot tries to fetch policies from your Google Doc
2. If successful, uses Google Doc content
3. If Google Doc is unavailable, falls back to local file

### When You Click "Reload Policies":
1. Bot fetches the latest content from Google Doc
2. Updates its knowledge base
3. Immediately starts using new content
4. No restart required!

### Behind the Scenes:
- Bot uses Google Docs export API: `/export?format=txt`
- Converts your formatted document to plain text
- Caches it in memory for fast responses
- Tracks last update time

---

## 🎯 Best Practices

### ✅ DO:
- Keep all policies in one document (easier to manage)
- Use clear headings and formatting
- Test changes in chatbot after updating
- Keep a backup copy of your policies

### ❌ DON'T:
- Don't change document permissions to private
- Don't delete the document (bot will fail)
- Don't make the document editable by everyone
- Don't forget to reload policies after major changes

---

## 🔧 Configuration

### For Your Dev Team:

The Google Doc ID is configured in the backend. To change it:

**Option 1: Environment Variable (Recommended)**
```bash
export GOOGLE_DOC_ID="your-new-document-id"
```

**Option 2: In Code**
Edit `backend/app.py`, line 33:
```python
GOOGLE_DOC_ID = os.environ.get("GOOGLE_DOC_ID", "1I3XoFUvTFgjJPck8MahPeAIMuodlkPZSj4Y7kyVXscI")
```

---

## 📊 Monitoring

### Check Policy Source:

**Via Health Check:**
```bash
curl http://your-domain.com/api/health
```

Response will show:
```json
{
  "status": "healthy",
  "policy_source": "Google Docs",
  "policy_length": 45231,
  "last_updated": "2025-01-15T10:30:00"
}
```

**Via Policy Info:**
```bash
curl http://your-domain.com/api/policy-info
```

Shows detailed information including:
- Google Doc URL
- Policy length
- Last update time
- Preview of content

---

## 🆘 Troubleshooting

### Problem: Bot says "Policies not loaded"

**Solution:**
1. Check if Google Doc is public ("Anyone with the link")
2. Try reloading policies via admin panel
3. Check if document ID is correct
4. As fallback, bot will use local file if available

### Problem: Changes not reflecting in bot

**Solution:**
1. Make sure you saved changes in Google Doc (auto-saves)
2. Click "Reload Policies" in admin panel
3. Wait a few seconds for reload to complete
4. Test again with a question

### Problem: "Failed to load from Google Docs"

**Solution:**
1. Verify document is public
2. Check your internet connection
3. Try accessing the export URL directly:
   ```
   https://docs.google.com/document/d/1I3XoFUvTFgjJPck8MahPeAIMuodlkPZSj4Y7kyVXscI/export?format=txt
   ```
4. If still failing, bot will use local file as fallback

---

## 🔐 Security Notes

### Is My Data Safe?

✅ **Yes!** Here's why:
- Document is set to "view only" - nobody can edit without permission
- Only the chatbot reads it (via export API)
- No data is stored externally except in your server's memory
- OpenAI API only sees the content when processing questions

### Who Can See My Policies?

- Anyone with the link can **view** the Google Doc
- But only authorized users can **access the chatbot**
- Consider adding authentication to your chatbot if needed

---

## 💡 Tips & Tricks

### Tip 1: Use Clear Formatting
Your Google Doc formatting (headings, bold, bullets) helps organize content, though the bot reads it as plain text.

### Tip 2: Test Before Announcing
After major policy updates:
1. Update Google Doc
2. Reload policies
3. Test with sample questions
4. Then announce to team

### Tip 3: Keep a Changelog
Add a "Last Updated" section at the top of your Google Doc to track changes.

### Tip 4: Backup Regularly
Periodically download a copy of your Google Doc (File → Download → Plain Text) as backup.

---

## 📞 Support

### For Policy Content Questions:
- Contact your HR team

### For Technical Issues:
- Check this guide first
- Contact your IT/Dev team
- Provide error messages if any

---

## ✅ Quick Reference

| Action | How To |
|--------|--------|
| Update policies | Edit Google Doc directly |
| Apply changes | Click "Reload Policies" in admin panel |
| Check if working | Visit `/api/health` endpoint |
| View current content | Visit `/api/policy-info` endpoint |
| Change document | Update `GOOGLE_DOC_ID` environment variable |
| Fallback to local | Bot automatically uses local file if Google Docs fails |

---

**You're all set! Your chatbot now stays in sync with your Google Doc automatically.** 🎉
