# Simple Guide - What to Give Your Dev Team

## 📦 Step 1: Give Them the ZIP File

**Give your dev team the ENTIRE ZIP file** (`company-policy-chatbot-BEST.zip`)

Tell them: *"Please deploy this company policy chatbot to our server."*

---

## 📄 Step 2: Give Them This Document

Also give them the file: **`FOR_DEV_TEAM.md`** (included in the ZIP)

This document has all the technical instructions they need.

---

## ⏱️ Step 3: Wait for Deployment (30-60 minutes)

Your dev team will:
1. Upload files to your company server
2. Install required software
3. Configure the web server
4. Set up SSL certificate (HTTPS)
5. Test everything

---

## 🌐 Step 4: Get the Embed Code

After deployment, your dev team will give you:

### 1. **Chatbot URL**
Example: `https://chatbot.yourcompany.com`

### 2. **Embed Code** (Choose one option)

They'll provide code like this:

#### Option A: Floating Chat Button (Recommended)
```html
<script>
(function() {
    var btn = document.createElement('button');
    btn.innerHTML = '💬';
    btn.style.cssText = 'position:fixed;bottom:20px;right:20px;...';
    // ... more code ...
    iframe.src = 'https://chatbot.yourcompany.com/index.html';
    // ... more code ...
})();
</script>
```

**What it looks like:** A chat button in the bottom-right corner of your website. Click to open the chatbot.

#### Option B: Embedded in Page
```html
<iframe 
    src="https://chatbot.yourcompany.com/index.html" 
    style="width:100%; height:600px; border:none;">
</iframe>
```

**What it looks like:** Chatbot embedded directly in your page content.

---

## 📝 Step 5: Add to Your Website

Give the embed code to your web developer/designer and tell them:

**For Option A (Floating Button):**
*"Please add this code to all pages, just before the closing `</body>` tag."*

**For Option B (Embedded):**
*"Please add this code to the [specific page] where we want the chatbot."*

---

## ✅ Step 6: Test It

After it's added to your website:

1. **Visit your website**
2. **Look for the chat button** (bottom-right corner) OR **scroll to the chatbot section**
3. **Click to open** the chatbot
4. **Ask a question:** "What is the sick leave policy?"
5. **Verify it answers** from your company policies

---

## 🔄 How to Update Policies in Future

You have **2 options**:

### Option 1: Ask Dev Team (Simple)
1. Edit `company_policies.txt` in Notepad on your computer
2. Send the updated file to your dev team
3. They'll upload it to the server (takes 2 minutes)
4. Go to admin panel and click "Reload Policies"

### Option 2: Do It Yourself (If dev team gives you access)
1. Log in to admin panel: `https://chatbot.yourcompany.com/admin.html`
2. Click "Reload Policies" button
3. Done!

**No restart needed!** Changes take effect immediately.

---

## 📊 What to Expect

### Performance
- **Response time:** 2-4 seconds per question
- **Accuracy:** Answers only from your policy handbook
- **Availability:** 24/7 (always online)

### Cost
- **Server:** $5-10/month (or use existing company server - free)
- **OpenAI API:** $5-25/month for 100 employees
- **Total:** ~$10-35/month

### Benefits
- Employees get instant answers
- Reduces HR workload
- Available 24/7
- Easy to update

---

## 🎯 Quick Summary

| What You Do | What Dev Team Does |
|-------------|-------------------|
| Give them the ZIP file | Upload to server |
| Give them FOR_DEV_TEAM.md | Install & configure |
| Wait 30-60 minutes | Test deployment |
| Get embed code from them | Provide embed code |
| Give embed code to web designer | Add to website |
| Test on your website | Monitor & maintain |

---

## 📞 Questions to Ask Your Dev Team

After deployment, ask them:

1. **"What is the chatbot URL?"**
   - They'll give you something like: `https://chatbot.yourcompany.com`

2. **"What is the embed code for our main website?"**
   - They'll give you the HTML code to add

3. **"What is the admin panel URL?"**
   - They'll give you: `https://chatbot.yourcompany.com/admin.html`

4. **"How do I update policies in the future?"**
   - They'll explain the process (usually: edit file → upload → reload)

---

## ✅ Checklist

Before considering it "done", verify:

- [ ] Dev team has the ZIP file
- [ ] Dev team has the FOR_DEV_TEAM.md document
- [ ] Chatbot is deployed and accessible via URL
- [ ] You received the embed code
- [ ] Embed code is added to your website
- [ ] Chatbot appears on your website
- [ ] Chatbot responds to questions correctly
- [ ] You know how to update policies
- [ ] You have admin panel access

---

## 🎉 That's It!

Once your dev team deploys it and gives you the embed code, you're done! The chatbot will be live on your website and employees can start using it immediately.

**No technical knowledge required on your part** - your dev team handles all the technical setup, and you just need to add the embed code to your website (or ask your web designer to do it).
