# Deployment Checklist - DWS Policy Chatbot

Use this checklist to ensure a smooth deployment to your production server.

## 📋 Pre-Deployment

- [ ] **Server Requirements Met**
  - [ ] Ubuntu/Debian Linux server (or compatible)
  - [ ] Python 3.8 or higher installed
  - [ ] Root or sudo access
  - [ ] Domain name configured (optional but recommended)

- [ ] **API Key Ready**
  - [ ] OpenAI API key obtained
  - [ ] API key tested and working
  - [ ] Billing configured on OpenAI account

- [ ] **Content Prepared**
  - [ ] Company policies document reviewed
  - [ ] Content updated in `data/company_policies.txt`
  - [ ] Sensitive information removed or anonymized

## 🚀 Deployment Steps

### 1. Server Setup

- [ ] Connect to server via SSH
- [ ] Update system packages
  ```bash
  sudo apt update && sudo apt upgrade -y
  ```
- [ ] Install required packages
  ```bash
  sudo apt install -y python3 python3-pip nginx
  ```

### 2. Upload Project

- [ ] Upload project to server
  ```bash
  scp company-policy-chatbot.zip user@your-server:/tmp/
  ```
- [ ] Extract on server
  ```bash
  sudo unzip /tmp/company-policy-chatbot.zip -d /var/www/
  sudo chown -R www-data:www-data /var/www/company-policy-chatbot
  ```

### 3. Backend Configuration

- [ ] Install Python dependencies
  ```bash
  cd /var/www/company-policy-chatbot/backend
  pip3 install -r requirements.txt
  ```
- [ ] Set up environment variables
  ```bash
  sudo nano /etc/environment
  # Add: OPENAI_API_KEY="your-key-here"
  ```
- [ ] Copy systemd service file
  ```bash
  sudo cp /var/www/company-policy-chatbot/policy-chatbot.service /etc/systemd/system/
  sudo nano /etc/systemd/system/policy-chatbot.service
  # Update: OPENAI_API_KEY and paths
  ```
- [ ] Create log directory
  ```bash
  sudo mkdir -p /var/log/policy-chatbot
  sudo chown www-data:www-data /var/log/policy-chatbot
  ```
- [ ] Start and enable service
  ```bash
  sudo systemctl daemon-reload
  sudo systemctl start policy-chatbot
  sudo systemctl enable policy-chatbot
  sudo systemctl status policy-chatbot
  ```

### 4. Nginx Configuration

- [ ] Copy nginx configuration
  ```bash
  sudo cp /var/www/company-policy-chatbot/nginx.conf /etc/nginx/sites-available/policy-chatbot
  sudo nano /etc/nginx/sites-available/policy-chatbot
  # Update: server_name to your domain
  ```
- [ ] Enable site
  ```bash
  sudo ln -s /etc/nginx/sites-available/policy-chatbot /etc/nginx/sites-enabled/
  ```
- [ ] Test nginx configuration
  ```bash
  sudo nginx -t
  ```
- [ ] Restart nginx
  ```bash
  sudo systemctl restart nginx
  ```

### 5. Frontend Configuration

- [ ] Update API URL in frontend
  ```bash
  sudo nano /var/www/company-policy-chatbot/frontend/script.js
  # Change API_URL to: http://your-domain.com/api
  ```
- [ ] Update API URL in admin panel
  ```bash
  sudo nano /var/www/company-policy-chatbot/frontend/admin.html
  # Change API_URL to: http://your-domain.com/api
  ```

### 6. SSL Setup (Recommended)

- [ ] Install certbot
  ```bash
  sudo apt install -y certbot python3-certbot-nginx
  ```
- [ ] Obtain SSL certificate
  ```bash
  sudo certbot --nginx -d your-domain.com
  ```
- [ ] Test auto-renewal
  ```bash
  sudo certbot renew --dry-run
  ```
- [ ] Update frontend to use HTTPS
  ```bash
  # Change API_URL to: https://your-domain.com/api
  ```

## ✅ Post-Deployment Testing

- [ ] **Backend Health Check**
  ```bash
  curl http://your-domain.com/api/health
  ```
  Expected: `{"status":"healthy","policies_loaded":true,...}`

- [ ] **Frontend Access**
  - [ ] Visit `http://your-domain.com`
  - [ ] Chat interface loads correctly
  - [ ] No console errors in browser

- [ ] **Chat Functionality**
  - [ ] Ask: "What is the sick leave policy?"
  - [ ] Response is accurate and relevant
  - [ ] Response time is acceptable (< 10 seconds)

- [ ] **Admin Panel**
  - [ ] Visit `http://your-domain.com/admin.html`
  - [ ] Policy info displays correctly
  - [ ] "Reload Policies" button works

- [ ] **Widget Embed**
  - [ ] Visit `http://your-domain.com/embed.html`
  - [ ] Widget button appears
  - [ ] Chat window opens on click

## 🔒 Security Checklist

- [ ] **API Key Security**
  - [ ] API key stored in environment variable
  - [ ] API key not in any code files
  - [ ] API key not in version control

- [ ] **CORS Configuration**
  - [ ] Update `backend/app.py` CORS settings
  - [ ] Change `allow_origins=["*"]` to specific domain
  - [ ] Example: `allow_origins=["https://your-domain.com"]`

- [ ] **Firewall Configuration**
  - [ ] Only ports 80 and 443 open to public
  - [ ] Port 8000 (backend) only accessible from localhost
  ```bash
  sudo ufw allow 80/tcp
  sudo ufw allow 443/tcp
  sudo ufw enable
  ```

- [ ] **File Permissions**
  - [ ] Backend files owned by www-data
  - [ ] Policy file readable by www-data
  - [ ] No world-writable files

## 📊 Monitoring Setup

- [ ] **Log Monitoring**
  - [ ] Backend logs: `/var/log/policy-chatbot/`
  - [ ] Nginx logs: `/var/log/nginx/`
  - [ ] Set up log rotation

- [ ] **Service Monitoring**
  ```bash
  # Check if service is running
  sudo systemctl status policy-chatbot
  
  # View recent logs
  sudo journalctl -u policy-chatbot -n 50 -f
  ```

- [ ] **Uptime Monitoring** (Optional)
  - [ ] Set up external monitoring (UptimeRobot, Pingdom, etc.)
  - [ ] Monitor: `http://your-domain.com/api/health`

## 🎯 Final Steps

- [ ] **Documentation**
  - [ ] Share chatbot URL with employees
  - [ ] Document how to update policies
  - [ ] Create internal wiki page

- [ ] **Training**
  - [ ] Train HR team on content updates
  - [ ] Show how to use admin panel
  - [ ] Explain reload process

- [ ] **Backup**
  - [ ] Backup policy file
  - [ ] Document server configuration
  - [ ] Save API keys securely

- [ ] **Maintenance Plan**
  - [ ] Schedule regular policy updates
  - [ ] Plan for monthly reviews
  - [ ] Set up alerts for downtime

## 🆘 Emergency Contacts

- **Server Issues**: Your IT Team
- **API Issues**: OpenAI Support
- **Application Issues**: Check logs first, then contact developer

## 📝 Notes

- Backend runs on port 8000 (internal only)
- Frontend served by Nginx on ports 80/443
- Policy file location: `/var/www/company-policy-chatbot/data/company_policies.txt`
- To update policies: Edit file → Reload via admin panel
- No restart required for policy updates

---

**Deployment Date**: _______________  
**Deployed By**: _______________  
**Server**: _______________  
**Domain**: _______________
